const cartItemsContainer = document.getElementById("cart-items");
const totalCountEl = document.getElementById("total-count");
const totalPriceEl = document.getElementById("total-price");
const totalPrice2El = document.getElementById("total-price-2");

function loadCart() {
  const cart = JSON.parse(localStorage.getItem("cart")) || [];
  const emptyCartMessage = document.getElementById("empty-cart");
  const cartSummary = document.querySelector(".cart-summary");

  cartItemsContainer.innerHTML = "";

  if (cart.length === 0) {
    emptyCartMessage.style.display = "block";
    cartSummary.style.display = "none";
    updateSummary(cart);
    return;
  }

  emptyCartMessage.style.display = "none";
  cartSummary.style.display = "block";

  cart.forEach(item => {
    const cartItem = document.createElement("div");
    cartItem.className = "cart-item";
    cartItem.innerHTML = `
      <img src="${item.image}" alt="${item.name}">
      <div class="item-details">
        <div>${item.name}</div>
        <small>${item.description}</small>
      </div>
      <div class="price">${item.price.toFixed(2)} ₽</div>
      <div class="quantity-controls" style="width: 120px;">
        <button class="decrease" data-id="${item.positionId}">−</button>
        <span class="quantity">${item.quantity}</span>
        <button class="increase" data-id="${item.positionId}">+</button>
      </div>
      <div class="total">${(item.price * item.quantity).toFixed(2)} ₽</div>
      <button class="remove-item styled-button" data-id="${item.positionId}">Удалить</button>
    `;
    cartItemsContainer.appendChild(cartItem);
  });

  updateSummary(cart);
  setupButtons();
}

function updateSummary(cart) {
  const totalCount = cart.reduce((sum, item) => sum + item.quantity, 0);
  const totalPrice = cart.reduce((sum, item) => sum + item.price * item.quantity, 0);
  totalCountEl.textContent = totalCount;
  totalPriceEl.textContent = totalPrice.toFixed(2);
  totalPrice2El.textContent = totalPrice.toFixed(2);

  const payButton = document.getElementById("iawBtn");
  if (payButton) {
    payButton.setAttribute("data-price", totalPrice.toFixed(2));
  }
}

function setupButtons() {
  document.querySelectorAll(".increase").forEach(btn => {
    btn.addEventListener("click", () => {
      const cart = JSON.parse(localStorage.getItem("cart")) || [];
      const id = btn.dataset.id;
      const index = cart.findIndex(i => String(i.positionId) === id);
      if (index !== -1) {
        cart[index].quantity += 1;
        cart[index].amount = cart[index].price * cart[index].quantity;
        localStorage.setItem("cart", JSON.stringify(cart));

        const cartItem = btn.closest(".cart-item");
        cartItem.querySelector(".quantity").textContent = cart[index].quantity;
        cartItem.querySelector(".total").textContent = cart[index].amount.toFixed(2) + " ₽";

        updateSummary(cart);
      }
    });
  });

  document.querySelectorAll(".decrease").forEach(btn => {
    btn.addEventListener("click", () => {
      const cart = JSON.parse(localStorage.getItem("cart")) || [];
      const id = btn.dataset.id;
      const index = cart.findIndex(i => String(i.positionId) === id);
      if (index !== -1) {
        cart[index].quantity -= 1;

        if (cart[index].quantity <= 0) {
          const cartItem = btn.closest(".cart-item");
          cartItem.classList.add("fade-out");

          setTimeout(() => {
            cart.splice(index, 1);
            localStorage.setItem("cart", JSON.stringify(cart));
            loadCart();
          }, 300);
        } else {
          cart[index].amount = cart[index].price * cart[index].quantity;
          localStorage.setItem("cart", JSON.stringify(cart));

          const cartItem = btn.closest(".cart-item");
          cartItem.querySelector(".quantity").textContent = cart[index].quantity;
          cartItem.querySelector(".total").textContent = cart[index].amount.toFixed(2) + " ₽";

          updateSummary(cart);
        }
      }
    });
  });

  document.querySelectorAll(".remove-item").forEach(btn => {
    btn.addEventListener("click", () => {
      const positionId = btn.dataset.id;
      const cartItem = btn.closest(".cart-item");

      cartItem.classList.add("fade-out");

      setTimeout(() => {
        let cart = JSON.parse(localStorage.getItem("cart")) || [];
        cart = cart.filter(item => String(item.positionId) !== String(positionId));
        localStorage.setItem("cart", JSON.stringify(cart));
        loadCart();
      }, 300);
    });
  });
}

document.addEventListener("DOMContentLoaded", () => {
  loadCart();

  const emailInput = document.getElementById("client-email");
  const savedEmail = localStorage.getItem("clientEmail");

  if (savedEmail && emailInput) {
    emailInput.value = savedEmail;
  }

  emailInput?.addEventListener("input", () => {
    localStorage.setItem("clientEmail", emailInput.value.trim());
  });
});
